function [ f ] = fct_pdf_f(t,mu,sigma)
% pdf of the times tau a Brownian motion {X(t)} with (mu,sigma)  hits
% X(tau)=1 starting at X(0)=0.
% 
mu_orig = mu;
mu = abs(mu);
f = t.^(-3/2)./(sigma*sqrt(2*pi)).* exp( -(mu .* t - 1 ).^2 ./ (2.*sigma.^2 .* t) );

% if t=0, enter f=0
sel = t==0;
f(sel)=0;

% negative mu
if mu_orig <0
    f = exp(-2*mu/sigma^2)*f;
end
end

